@extends('layouts.app')
@section('title', translate('common.unit_edit'))
@section('content')
    <x-container title="unit edit" buttonRoute="{{ route('unit.index') }}" buttonTitle="Back">
        <form class="form" method="POST" action="{{ route('unit.update', $unit->id) }}">
            @csrf
            @method('put')
            <div class="row">
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="first-name-column">{{ translate('common.name') }}</label>
                        <input type="text" id="first-name-column" class="form-control"
                               placeholder="{{ translate('common.name') }}" value="{{ $unit->name }}"
                               name="name" required>
                    </div>
                </div>
                <div class="col-12">
                    <button type="submit"
                            class="btn btn-primary me-1 waves-effect waves-float waves-light">{{ translate('common.submit') }}</button>
                    <button type="reset"
                            class="btn btn-outline-secondary waves-effect">{{ translate('common.reset') }}</button>
                </div>
            </div>
        </form>
    </x-container>
@endsection
