@extends('layouts.backend')
@section('title', "Upcoming Expire Medicines")
@section('content')
    <x-container title="Upcoming Expire Medicines">
        <div class="table-responsive pt-0">
            <table class="table">
                <x-table.thead :headers="['Medicine','Batch','Expire On']"></x-table.thead>
                <tbody>
                @forelse($collection as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ @$row->medicine->name }}</td>
                        <td>{{ $row->name }}</td>
                        <td>{{ date('F d Y', strtotime($row->expire)) }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center">
                            <h4 class="py-5">{{ translate('common.Empty ):') }}</h4>
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
            <div class="pagination">
                {!! $collection->links() !!}
            </div>
        </div>
    </x-container>
@endsection