@extends('layouts.backend')
@section('title', 'Medicines')
@section('content')
    <x-container title="Medicines" buttonTitle="Add New" buttonRoute="{{ route('medicines.create') }}">
        <form method="get" action="" class="row mb-1">
            <div class="col-lg-3">
                <select name="supplier_id" id="" class="form-select">
                    <option value="" selected="">{{ translate('common.Supplier') }}</option>
                    @foreach($suppliers as $supplier)
                    <option {{ request('supplier_id') == $supplier->id ? 'selected' : '' }} value="{{ $supplier->id }}">{{ $supplier->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-lg-6">
                <input type="text" value="{{ request('keyword') }}" class="form-control" name="keyword" placeholder="Search with QR code, name, generic">
            </div>
            <div class="col-lg-2">
                @if(request()->query())
                <a href="{{ url()->current() }}" class="btn btn-danger"><i class="fa fa-times"></i></a>
                @endif
                <button type="submit" class="btn btn-dark"><i class="fa fa-search"></i></button>
            </div>
        </form>
        <div class="table-responsive pt-0">
            <table class="table">
                <thead>
                <tr>
                    <th>{{ translate('common.sn') }}</th>
                    <th>{{ translate('common.qr_code') }}</th>
                    <th>{{ translate('common.medicine_name') }}</th>
                    <th>{{ translate('common.generic_name') }}</th>
                    <th>{{ translate('common.category') }}</th>
                    <th>{{ translate('common.supplier') }}</th>
                    <th>{{ translate('common.price') }}</th>
                    <th>{{ translate('common.buy_price') }}</th>
                    <th>{{ translate('common.option') }}</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($collection as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $row->qr_code }}</td>
                        <td>
                            <div class="d-flex align-items-center gap-1">
                                <img height="30" width="30" src="{{ globalAsset($row->image) }}" alt="{{ $row->name }}">
                                <span>{{ $row->name }}</span>
                            </div>
                        </td>
                        <td>{{ $row->generic_name }}</td>
                        <td>
                            @foreach($row->category_names as $categoryName)
                                <span class="badge bg-dark">{{ $categoryName }}</span>
                            @endforeach
                        </td>
                        <td>{{ @$row->supplier->name }}</td>
                        <td>{{ priceFormat(@$row->price) }}</td>
                        <td>{{ priceFormat(@$row->buy_price) }}</td>
                        <td class="d-flex gap-1">
                            <x-action.edit route="{{ route('medicines.edit', $row->id) }}"></x-action.edit>
                            <x-action.delete route="{{ route('medicines.delete', $row->id) }}"></x-action.delete>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
            {!! $collection->links() !!}
        </div>
    </x-container>
@endsection
