@extends('layouts.backend')
@section('title', "Edit language terms")
@push('css')
    <style>
        .language-terms{

        }
    </style>
    @endpush
@section('content')
    <x-container title="Edit language terms" buttonTitle="Back" buttonRoute="{{ route('language.index') }}">
        <p><i class="fa fa-info-circle"></i> You are translating <b>English</b> to <b>{{ $language->name }}</b></p>
        <form action="{{ route('language.terms.update', $language->id) }}" method="post" class="row"
              enctype="multipart/form-data">
            @csrf
            <x-form.select
                    onchange="changeLanguageModuleHandler(this.value)"
                    name="module"
                    label="Module"
                    col="col-md-12">
                @foreach($modules as $module)
                    <option {{ request('module') == $module? 'selected':'' }} value="{{ $module }}">{{ ucfirst($module) }}</option>
                @endforeach
            </x-form.select>

            <div></div>

            <div class="language-terms">
                @foreach($jsonString as $key => $value)
                    <div class="row mb-1">
                        <div class="col-md-6 input-component">
                            <input type="hidden" name="str_key[]" value="{{ $key }}">
                            <input readonly="readonly" type="text" class="form-control disabled text-capitalize" value="{{ str_replace('_',' ', $key) }}">
                        </div>
                        <div class="col-md-6 input-component">
                            <input type="text" class="form-control" value="{{ $value }}" name="str_value[]">
                        </div>
                    </div>
                @endforeach
            </div>
            <x-form.button></x-form.button>
        </form>
    </x-container>
@endsection

@push('js')
    <script>
        const changeLanguageModuleHandler = (module) => {
            let currentUrl = new URL(window.location.href);
            currentUrl.searchParams.set('module', module)
            window.location.href = currentUrl.href;
        }
    </script>
@endpush