@extends('layouts.backend')
@section('title', translate('title.Add new customer'))
@section('content')
    <x-container title="Add new customer" buttonTitle="Back to list" buttonRoute="{{ route('customer.index') }}">
        <form action="{{ route('customer.store') }}" method="post" class="row">
            @csrf
            <x-form.input
                    name="name"
                    label="Name"
                    value="{{ @old('name') }}"
                    col="col-md-6">
            </x-form.input>
            <x-form.input
                    name="email"
                    label="Email"
                    value="{{ @old('email') }}"
                    col="col-md-6">
            </x-form.input>
            <x-form.input
                    name="phone"
                    label="Phone"
                    value="{{ @old('phone') }}"
                    col="col-md-6">
            </x-form.input>
            <x-form.input
                    type="number"
                    name="due"
                    label="Due"
                    value="{{ @old('due') }}"
                    col="col-md-6">
            </x-form.input>
            <x-form.textarea
                    name="address"
                    label="Address"
                    value="{{ @old('address') }}"
                    col="col-md-12">
            </x-form.textarea>
            <x-form.button></x-form.button>
        </form>
    </x-container>
@endsection