@extends('layouts.app')
@section('title', translate('common.category_add'))
@section('content')
    <x-container title="Add Category" buttonTitle="Back" buttonRoute="{{ route('categories.index') }}">
        <form id="websiteSettingForm" method="post" action="{{ route('categories.store') }}"
              enctype="multipart/form-data">
            <div class="row g-2 justify-content-center">
                <div class="col-lg-6 row g-2">
                    <div class="col-sm-12">
                        <label class="form-label">{{ translate('common.Title') }}</label>
                        <input type="text" name="title" placeholder="Enter Title" class="form-control">
                        @error('title')
                        <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="col-md-12">
                        <label for="image" class="form-label file-selectore">
                            <span class="label">{{ translate('common.Select category image (size: 140 × 140 px)') }}</span>
                        </label>
                        <input type="file" class="d-block my-2" name="image" id="image">
                    </div>
                    <div class="col-md-12">
                        <label for="banner" class="form-label file-selectore">
                             <span class="label">{{ translate('common.Select banner image (size: 1350 × 250 px)') }}</span>
                        </label>
                        <input type="file" class="d-block my-2" name="banner" id="banner">
                    </div>

                    @php
                        $sorting = \App\Models\ProductCategory::count();
                    @endphp
                    <div class="col-sm-6">
                        <label class="form-label">{{ translate('common.Sorting') }}</label>
                        <input value="{{ $sorting + 1 }}" type="number" name="sorting"
                               placeholder="Enter sorting" class="form-control">
                        @error('sorting')
                        <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="col-sm-6">
                        <label class="form-label d-block">{{ translate('common.Status') }}</label>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" checked type="radio" name="status" id="active"
                                   value="active">
                            <label class="form-check-label"
                                   for="active">{{ translate('common.Active') }}</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="status" id="inactive"
                                   value="inactive">
                            <label class="form-check-label"
                                   for="inactive">{{ translate('common.Inactive') }}</label>
                        </div>
                        @error('status')
                        <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="col-lg-12">
                        <div class="row">
                            <div class="col-lg-6 mb-3">
                                <div class="form-check">
                                    <input type="hidden" name="show_in_home" value="0">
                                    <input class="form-check-input" name="show_in_home" type="checkbox"
                                           value="1" id="home">
                                    <label class="form-check-label" for="home">
                                        {{ translate('common.Show in home') }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <div class="form-check">
                                    <input type="hidden" name="show_in_menu" value="0">
                                    <input class="form-check-input" name="show_in_menu" type="checkbox"
                                           value="1" id="top-menu">
                                    <label class="form-check-label" for="top-menu">
                                        {{ translate('common.Show in top menu') }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <div class="form-check">
                                    <input type="hidden" name="top_category" value="0">
                                    <input class="form-check-input" name="top_category" type="checkbox"
                                           value="1" id="top-category">
                                    <label class="form-check-label" for="top-category">
                                        {{ translate('common.Top Category') }}
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <label class="form-label d-block">{{ translate('common.Type') }}</label>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" checked type="radio" name="type" id="inventory"
                                   value="inventory">
                            <label class="form-check-label" for="inventory">{{ translate('common.Inventory') }}</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="type" id="ecommerce"
                                   value="ecommerce">
                            <label class="form-check-label"
                                   for="ecommerce">{{ translate('common.Ecommerce') }}</label>
                        </div>
                        @error('type')
                        <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="gap-3 mt-2 text-end">
                        <button type="submit" class="btn btn-primary btn-border btn-success">
                            <span> {{ translate('common.submit') }}</span>
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </x-container>
@endsection
