@extends('layouts.backend')
@section('title', "Balance Sheet")
@section('content')
    <x-container title="Balance Sheets">
        <div class="text-end">
            <a href="javascript:" id="window-printer" onclick="return(window.print())" class="btn btn-sm btn-success mb-2">
                <i class="fa fa-print"></i>
                {{ translate('common.Print') }}
            </a>
        </div>
        <div class="table-responsive pt-0">
            <table class="table">
                <thead>
                <tr>
                    <th>{{ translate('common.Account Name') }}</th>
                    <th>{{ translate('common.Balance') }}</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <th><h4>{{ translate('common.Assets') }}</h4></th>
                </tr>
                @foreach($balanceSheet['assets'] as $balance)
                    <tr>
                        <td class="name">{{ $balance->account_name }}</td>
                        <td>{{  priceFormat($balance->balance) }}</td>
                    </tr>
                @endforeach
                <tr>
                    <td><h5>{{ translate('common.Total') }}</h5></td>
                    <td><h5 class="text-decoration-underline">{{  priceFormat($balanceSheet['totalAssets']) }}</h5></td>
                </tr>
                <tr>
                    <th><h4>{{ translate('common.liabilities') }}</h4></th>
                </tr>
                @foreach($balanceSheet['liabilities'] as $balance)
                    <tr>
                        <td class="name">{{ $balance->account_name }}</td>
                        <td>{{  priceFormat($balance->balance) }}</td>
                    </tr>
                @endforeach
                <tr>
                    <td><h5>{{ translate('common.Total') }}</h5></td>
                    <td><h5 class="text-decoration-underline">{{  priceFormat($balanceSheet['totalLiabilities']) }}</h5>
                    </td>
                </tr>

                <tr>
                    <th><h4>{{ translate('common.equity') }}</h4></th>
                </tr>
                @foreach($balanceSheet['equity'] as $balance)
                    <tr>
                        <td class="name">{{ $balance->account_name }}</td>
                        <td>{{  priceFormat($balance->balance) }}</td>
                    </tr>
                @endforeach
                <tr>
                    <td><h5>{{ translate('common.Total') }}</h5></td>
                    <td><h5 class="text-decoration-underline">{{  priceFormat($balanceSheet['totalEquity']) }}</h5></td>
                </tr>
                <tr>
                    <td class="name"><h4>{{ translate('common.Total Liability and Equity') }}</h4></td>
                    <td><h4>{{ priceFormat($balanceSheet['totalLiabilitiesAndEquity']) }}</h4></td>
                </tr>
                </tbody>
            </table>
            <hr>
        </div>
    </x-container>
@endsection

@push('js')
    <script>
        function printWindow() {
            window.print();
        }
    </script>
@endpush