@extends('layouts.backend')
@section('title', "Accounts")
@section('content')
    <x-container title="Accounts" buttonTitle="Add New" buttonRoute="{{ route('accounts.create') }}">
        <div class="table-responsive pt-0">
            <table class="table">
                <x-table.thead :headers="['Account','Account Type','serial','status','action']"></x-table.thead>
                <tbody>
                @foreach($collection as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $row->name }}</td>
                        <td>{{ @$row->accountType->name }}</td>
                        <td>{{ @$row->serial }}</td>
                        <td>
                            <span class="badge {{ $row->status == 'active' ? 'bg-success' : 'bg-danger' }}">{{ $row->status }}</span>
                        </td>
                        @if($row->is_deletable)
                            <td class="d-flex gap-1">
                                <x-action.edit route="{{ route('accounts.edit', $row->id) }}"></x-action.edit>
                                <x-action.delete route="{{ route('accounts.destroy', $row->id) }}"></x-action.delete>
                            </td>
                        @else
                            <td>
                               <span class="text-danger"> {{ translate('common.No Action') }}</span>
                            </td>
                        @endif
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </x-container>
@endsection