<?php


namespace App\Repositories;


use App\Models\Medicine;

class MedicineRepository extends BaseRepository
{

    public function __construct(Medicine $model)
    {
        parent::__construct($model);
    }

    public function paginateData($request)
    {
       return $this->model->when($request->filled('keyword'), function ($query) use ($request){
            $query->whereRaw("name regexp '^{$request->keyword}.*'");
        })->latest()
            ->paginate($request->input('limit',10));
    }
}