<?php

namespace App\Models;

use App\Models\Ecommerce\DeliveryAddress;
use App\Models\Ecommerce\Eprescription;
use App\Models\Ecommerce\Order;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Request;
use Modules\MultiStore\App\Models\Store;

class Customer extends Authenticatable
{
    use Notifiable;

    protected  $guard = 'customer';
    protected $fillable = ['name','email','phone','type'];
    protected $hidden = [
        'password', 'remember_token',
    ];


    protected static function booted()
    {
        static::addGlobalScope('store_id', function (Builder $builder) {
            $storeId = request()->attributes->get('store_id');
            if ($storeId){
                if (isModuleActive('MultiStore')) {
                    $builder->where('store_id', $storeId);
                }
            }
        });
    }


    protected static function boot()
    {
        parent::boot();

        static::creating(function ($store) {
            if (!$store->store_id) {
                if (isModuleActive('MultiStore')) {
                    $store->store_id = Request::get('store_id');
                }
            }
        });
    }

    public function store()
    {
        if (isModuleActive('MultiStore')) {
            return $this->belongsTo(Store::class, 'store_id', 'id');
        }
        return null;
    }

    public function invoice(){
    	return $this->hasMany(Invoice::class);
    }
    
    public function invoice_pay(){
    	return $this->hasMany(InvoicePay::class);
    }
    
    public function district()
    {
        return $this->belongsTo(District::class);
    }
    
    public function thana()
    {
        return $this->belongsTo(Thana::class);
    }

    public function address()
    {
        return $this->hasMany(DeliveryAddress::class,'customer_id','id');
    }

    public function orders(): HasMany
    {
        return $this->hasMany(Order::class,'customer_id','id');
    }

    public function prescriptions()
    {
        return $this->hasMany(Eprescription::class,'customer_id','id');
    }
}
