<?php

namespace App\Http\Controllers;

use App\Models\Account\Account;
use App\Models\ExpenseCategory;
use App\Models\PharmacyExpense;
use App\Service\TransactionService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ExpenseController extends Controller
{
    public function index(Request $request)
    {
        $collection = PharmacyExpense::with('category')
            ->when($request->date, function($query) use ($request){
                $query->whereDate('date',$request->date);
            })
            ->latest()
            ->paginate(10);
        return view('expenses.index', compact('collection'));
    }

    public function create()
    {
        $categories = ExpenseCategory::select('id','name')->get();
        $accounts = Account::select('id','name')->where('status', 'active')->get();
        return view('expenses.create',compact('categories','accounts'));
    }

    public function store(Request $request)
    {
        try {
            $this->validation($request);
            DB::transaction(function () use ($request){
                PharmacyExpense::create($request->all());
                TransactionService::expenseTransaction($request->amount,$request->account_id, $request->title);
            });
            successAlert('Created successfully');
            return redirect()->route('expenses.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }

    public function edit($id)
    {
        $expense = PharmacyExpense::find($id);
        $categories = ExpenseCategory::select('id','name')->get();
        $accounts = Account::select('id','name')->where('status', 'active')->get();
        return view('expenses.edit',compact('categories','expense','accounts'));
    }

    public function update(Request $request, $id)
    {
        $this->validation($request);
        try {
            $expense = PharmacyExpense::find($id);
            $expense->update($request->all());
            successAlert('Updated successfully');
            return redirect()->route('expenses.index');
        } catch (\Exception $e) {
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }

    public function delete($id)
    {
        try {
            $expense = PharmacyExpense::find($id);
            $expense->delete();
            // Success message
            successAlert('Deleted successfully');
            return redirect()->route('expenses.index');
        } catch (\Exception $e) {
            // Error message
            errorAlert($e->getMessage());
            return redirect()->back();
        }
    }

    private function validation($request, $id = null)
    {
        $request->validate([
            'date' => 'required',
            'category_id' => 'required',
            'title' => 'required',
            'amount' => 'required',
        ]);
    }
}
