@extends('layouts.app')
@section('title', translate('common.Top sell medicine list'))
@section('custom-css')
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css"/>
@endsection
@if (request()->get('from') && request()->get('to'))
    @php
        $dto = request()->get('to');
        $dfrom = request()->get('from');
    @endphp
@else
    @php
        $dfrom = date('Y-m-d', strtotime('-7 day', time()));
        $dto = date('Y-m-d');
    @endphp
@endif



@php
    $datelist = list_days($dfrom, $dto);

@endphp
@php
    $setting = Auth::user()->shop;
@endphp
@section('content')
    <x-container title="Top sell medicine list">
        <div class="row px-2">
            <div class="col-lg-3">
                <form method="get">
                    <div class="col-md-12 user_role">
                        <label class="form-label" for="UserRole">{{ translate('common.from_date') }}</label>
                        <input value="@php echo $from_date @endphp  - @php echo $to_date @endphp" type="text"
                               name="date" id="reportrange"
                               class="form-control invoice-edit-input date-picker flatpickr-input">
                    </div>
                </form>
            </div>
            <div class="col-lg-6 float-end mb-2">
                <form method="get" class="d-flex align-items-end gap-1">
                    <div class="">
                        <label for=""></label>
                        <input type="search" name="keyword" class="form-control " placeholder="Search medicine.."
                               value="{{ $keyword }}" />
                    </div>
                    <button type="submit" class="btn btn-primary">{{ translate('common.Search') }}</button>
                </form>
            </div>
        </div>

        <table class="table">
            <thead>
            <tr>
                <th>{{ translate('common.sn') }}</th>
                <th>{{ translate('common.Medicine') }}</th>
                <th>{{ translate('common.Quantity') }}</th>
            </tr>
            </thead>
            <tbody>
            @forelse($medicines as $medicine)
                <tr>
                    <td> {{ $loop->iteration }} </td>
                    <td> {{ $medicine['name'] }} </td>
                    <td> {{ $medicine['total_sale'] }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="3" class="text-center">
                        <h4 class="py-5">{{ translate('common.No Data Found') }}</h4>
                    </td>
                </tr>
            @endforelse
            </tbody>
        </table>
    </x-container>
@endsection

@section('custom-js')
    <script type="text/javascript" src="https://cdn.jsdelivr.net/jquery/latest/jquery.min.js"></script>
    <script type = "text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js" ></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    @php
        $date = date('Y-m-d', strtotime('-7 day', time()));
    @endphp
    <!-- END: Page Vendor JS-->



    <script type="text/javascript">
        $(function () {


            var start = moment().subtract(29, 'days');
            var end = moment();

            var d = new Date();

            var up = function (start, end) {

                window.location.href = "?from=" + start + "&to=" + end;
            }

            $('input[name="date"]').daterangepicker({
                startDate: start,
                endDate: end,
                format: 'YYYY-MM-DD',
                timePicker: false,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                        'month').endOf('month')]
                }
            }, function (start, end, label) {
                var start2 = start.format("YYYY-MM-DD");
                var end2 = end.format("YYYY-MM-DD");

                window.start = start2;
                window.end = end2;

                up(start2, end2);
            });
        });
    </script>
@endsection

