@extends('layouts.app')
@section('title', __('Return History'))

@section('content')
    <x-container title="Return History">
        <div class="table-responsive">
            <table class="table table-bordered">
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">{{ translate('common.date') }}</th>
                    <th scope="col">{{ translate('common.amount') }}</th>
                    <th scope="col">{{ translate('common.Quantity') }}</th>
                    <th scope="col">{{ translate('common.Action') }}</th>
                </tr>
                <tbody>

                @forelse($return_data as $item)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $item->date }}</td>
                        <td>{{ $item->amount }}</td>
                        <td>{{ $item->quantity }}</td>
                        <td>
                            <a href="{{ route('purchase.return.invoice', $item->id) }}"
                               class="btn btn-sm btn-primary ">
                                {{ translate('Invoice') }}
                            </a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center">
                            <h4>{{ translate('common.No date found') }}!</h4>
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
        <div class="pagination mt-2">
            {!! $return_data->links() !!}
        </div>
    </x-container>

@endsection