@extends('layouts.app')
@section('title', translate('common.Edit Payment method'))
@section('content')
    <x-container title="Edit Payment method" buttonRoute="{{ route('payment_method.index') }}" buttonTitle="Back">
        <form class="form" action="{{ route('payment_method.update', $method->id) }}" method="POST">
            @csrf
            @method('put')
            <div class="row">
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="first-name-column">{{ translate('common.name') }}</label>
                        <input type="text" id="first-name-column" class="form-control"
                               placeholder="{{ translate('common.name') }}" name="name" value="{{ $method->name }}" required>
                    </div>
                </div>
                <div class="col-md-6 col-12">
                    <div class="mb-1">
                        <label class="form-label"
                               for="first-name-column">{{ translate('common.balance') }}</label>
                        <input type="number" step="0.01" id="first-name-column" class="form-control"
                               placeholder="Balance" name="balance" value="{{ $method->balance }}" required>
                    </div>
                </div>
                <div class="col-12">
                    <button type="submit"
                            class="btn btn-primary me-1 waves-effect waves-float waves-light">{{ translate('common.submit') }}</button>
                    <button type="reset"
                            class="btn btn-outline-secondary waves-effect">{{ translate('common.reset') }}</button>
                </div>
            </div>
        </form>
    </x-container>
@endsection
