@extends('layouts.backend')
@section('title', 'Languages')
@section('content')
    <x-container title="Languages" buttonTitle="Add New" buttonRoute="{{ route('language.create') }}">
        <div class="table-responsive pt-0">
            <table class="table">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Name</th>
                        <th>iso</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($collection as $row)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $row->name }}</td>
                            <td>
                                <img height="20" width="20" src="{{ @globalAsset($row->icon, 'language') }}"
                                    alt="">
                                <span>{{ $row->iso }}</span>
                            </td>
                            <td>
                                @if ($row->status)
                                    <span class="badge bg-success">{{ translate('common.Active') }}</span>
                                @else
                                    <span class="badge bg-danger">{{ translate('common.Inactive') }}</span>
                                @endif
                            </td>
                            <td class="d-flex gap-1">
                                <x-action.edit route="{{ route('language.edit', $row->id) }}"></x-action.edit>
                                <a class="btn btn-sm btn-warning border-radius-50 text-white"
                                    href="{{ route('language.terms.update', $row->id) }}">
                                    <i class="fa fa-edit"></i> Edit Terms
                                </a>
                                @if ($row->iso != 'en')
                                    <x-action.delete route="{{ route('language.delete', $row->id) }}"></x-action.delete>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </x-container>
@endsection
