@extends('layouts.backend')
@section('title', "Add new language")
@section('content')
    <x-container title="Add new language" buttonTitle="Back" buttonRoute="{{ route('language.index') }}">
        <form action="{{route('language.store')}}" method="post" class="row" enctype="multipart/form-data">
            @csrf
            <x-form.input
                    name="name"
                    label="Name"
                    value="{{ @old('name') }}"
                    placeholder="ex: english"
                    col="col-md-6">
            </x-form.input>
            <x-form.input
                    name="iso"
                    label="ISO"
                    value="{{ @old('iso') }}"
                    placeholder="ex: en"
                    col="col-md-6">
            </x-form.input>
            <x-form.file
                name="icon"
                label="Icon"
                col="col-md-6"
            ></x-form.file>
            <x-form.select
                    name="status"
                    label="Status"
                    value="{{ @old('status') }}"
                    col="col-md-6">
                <option value="1" selected>{{ translate('Active') }}</option>
                <option value="0">{{ translate('Inactive') }}</option>
            </x-form.select>
            <x-form.button></x-form.button>
        </form>
    </x-container>
@endsection