@extends('layouts.backend')
@section('title', translate('common.categories'))
@section('content')
    <x-container title="Categories" buttonTitle="Add New" buttonRoute="{{ route('categories.create') }}">
        <div class="table-responsive pt-0">
            <table class="table table-bordered">
                <tr>
                    <th>#</th>
                    <th>{{ translate('common.Image') }}</th>
                    <th>{{ translate('common.Banner') }}</th>
                    <th>{{ translate('common.Title') }}</th>
                    <th>{{ translate('common.Type') }}</th>
                    <th>{{ translate('common.Status') }}</th>
                    <th>{{ translate('common.Sorting') }}</th>
                    <th>{{ translate('common.Action') }}</th>
                </tr>
                @forelse($collection as $type)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>
                            <img height="40"
                                 src="{{ globalAsset($type->image) }}"
                                 alt="">
                        </td>
                        <td>
                            <img height="40"
                                 src="{{ globalAsset($type->banner) }}"
                                 alt="">
                        </td>
                        <td>{{ $type->title }}</td>
                        <td class="text-capitalize">{{ $type->type }}</td>
                        <td>
                            @if ($type->status == 'active')
                                <span class="badge bg-success">{{ translate('common.Active') }}</span>
                            @else
                                <span class="badge bg-danger">{{ translate('common.Inactive') }}</span>
                            @endif
                        </td>
                        <td>{{ $type->sorting }}</td>
                        <td class="d-flex gap-1">
                            <x-action.edit route="{{ route('categories.edit', $type->id) }}"></x-action.edit>
                            <x-action.delete route="{{ route('categories.delete', $type->id) }}"></x-action.delete>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6">
                            <h4 class="text-center my-5">{{ translate('common.No Data Avaiable') }}</h4>
                        </td>
                    </tr>
                @endforelse
            </table>
        </div>
    </x-container>
@endsection