@extends('layouts.backend')
@section('title', "Account Types")
@section('content')
<x-container title="Account Types" buttonTitle="Add New" buttonRoute="{{ route('account-types.create') }}">
    <div class="table-responsive pt-0">
        <table class="table">
            <x-table.thead :headers="['name','serial','status','action']"></x-table.thead>
            <tbody>
            @foreach($collection as $row)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $row->name }}</td>
                    <td>{{ $row->serial }}</td>
                    <td>
                        <span class="badge {{ $row->status == 'active' ? 'bg-success' : 'bg-danger' }}">{{ $row->status }}</span>
                    </td>

                    @if($row->is_deletable)
                        <td class="d-flex gap-1">
                            <x-action.edit route="{{ route('account-types.edit', $row->id) }}"></x-action.edit>
                            <x-action.delete route="{{ route('account-types.destroy', $row->id) }}"></x-action.delete>
                        </td>
                    @else
                        <td>
                            <span class="text-danger"> {{ translate('common.No Action') }}</span>
                        </td>
                    @endif
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
</x-container>
@endsection