<?php


namespace App\Http\Controllers;

use App\Models\Medicine;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class MedicineImport implements ToModel, WithHeadingRow
{
    /**
     * @param array $row
     *
     * @return Medicine|null
     */
    public function model(array $row)
    {
        return new Medicine([
            'qr_code'               => $row['qr_code'],
            'name'                  => $row['name'],
            'slug'                  => Str::slug($row['name']),
            'generic_name'          => $row['generic_name'],
            'price'                 => $row['price'],
            'buy_price'             => $row['buy_price'],
            'instock'               => $row['instock'],
            'strength'              => $row['strength'],
            'leaf_id'               => $row['leaf_id'],
            'type_id'               => $row['type_id'],
            'unit_id'               => $row['unit_id'],
            'shelf'                 => $row['shelf'],
            'categories'            => $row['categories'],
            'supplier_id'           => $row['supplier_id'],
            'vendor_id'             => $row['vendor_id'],
            'type'                  => $row['type'],
            'vat'                   => $row['vat'],
            'discount'              => $row['discount'],
            'description'           => $row['description'],
            'status'                => $row['status'],
            'igta'                  => $row['igta'],
            'hns_code'              => $row['hns_code'],
        ]);
    }
}