<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Password;

class CustomerResetPasswordController extends Controller
{

    use ResetsPasswords;

    protected $redirectTo = '/customer/dashboard'; // Adjust the redirect path as needed

    public function showResetForm(Request $request, $token = null)
    {
        return view('auth.customer.passwords.reset')->with(
            ['token' => $token, 'email' => $request->email]
        );
    }

    public function broker()
    {
        return Password::broker('customers'); // Use the customer password broker
    }

    protected function guard()
    {
        return Auth::guard('customer'); // Use the customer guard
    }
}
