@extends('layouts.app')
@section('title', translate('common.units'))
@section('content')
    <x-container title="Unit List" buttonRoute="{{ route('unit.create') }}" buttonTitle="Unit add">
        <div class="table-responsive">
            <table class="table">
                <thead>
                <tr>
                    <th>{{ translate('common.sn') }}</th>
                    <th>{{ translate('common.name') }}</th>
                    <th>{{ translate('common.option') }}</th>
                </tr>
                </thead>
                <tbody>
                @forelse($collection as $key => $row)
                  <tr>
                      <td>{{ $key + 1 }}</td>
                      <td>{{ $row->name }}</td>
                      <td class="d-flex gap-1">
                          <x-action.edit  route="{{ route('unit.edit', $row->id) }}"></x-action.edit>
                          <x-action.delete route="{{ route('unit.delete', $row->id) }}"></x-action.delete>
                      </td>
                  </tr>
                @empty
                    <tr>
                        <td colspan="3" class="text-center">
                            <h4 class="py-5">{{ translate('common.No Data Found') }}</h4>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </x-container>
@endsection