@extends('layouts.app')
@section('title', translate('common.customer_list'))
@section('content')
    <x-container title="{{ translate('Due Customers') }}">
        <div class="row justify-content-center">
            <div class="col-lg-4 mx-3 my-2">
                <div class="bg-primary p-2 text-center" role="alert">
                    <h2 class="text-light">Total Previous Due <br> <span class="">
                                {{ priceFormat($total_previous_due) }}
                            </span></h2>
                </div>
            </div>
            <div class="col-lg-4 mx-3 my-2">
                <div class="bg-warning p-2 text-center" role="alert">
                    <h2 class="text-light">Total Inovice Due <br> <span class="">
                                {{ priceFormat($total_invoice_due) }}</span></h2>
                </div>
            </div>
        </div>

        <div class="row justify-content-between align-items-center">
            <div class="col-lg-4">
                <form method="get" class="mb-1 d-flex align-items-center gap-2">
                    <input value="{{ request('keyword') }}" type="text"
                           name="keyword"
                           placeholder="Enter keyword"
                           class="form-control">
                    <button type="submit" class="btn btn-primary"><i class="fa fa-search"></i></button>
                </form>
            </div>

            <div class="col-lg-6 text-end">
                <x-table.export-option/>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table">
                <thead class="table-light">
                <tr>
                    <th>{{ translate('common.sn') }}</th>
                    <th>{{ translate('common.name') }}</th>
                    <th>{{ translate('common.phone') }}</th>
                    <th>Previous Dues</th>
                    <th>Invoice Dues</th>
                </tr>
                </thead>
                <tbody>
                @foreach($collection as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $row->name }}</td>
                        <td>{{ $row->phone }}</td>
                        <td>{{ priceFormat($row->due) }}</td>
                        <td>{{ priceFormat($row->invoice_due) }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            {!! $collection->links() !!}
        </div>

    </x-container>
@endsection
