@extends('layouts.backend')
@section('title', "Already Expire Medicines")
@section('content')
    <x-container title="Already Expire Medicines">
        <div class="table-responsive pt-0">
            <form action="" class="row mb-2">
                <div class="col-lg-3">
                    <input type="date" value="{{ request('date') }}" name="date" class="form-control">
                </div>
                <div class="col-lg-4">
                    <input type="text" value="{{ request('keyword') }}" placeholder="Enter keyword" name="keyword" class="form-control">
                </div>
                <div class="col-lg-4">
                    <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i></button>
                </div>
            </form>
            <table class="table">
                <x-table.thead :headers="['Medicine','Batch','Expire On','Action']"></x-table.thead>
                <tbody>
                @foreach($collection as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ @$row->medicine->name }}</td>
                        <td>{{ $row->name }}</td>
                        <td>{{ date('F d, Y', strtotime($row->expire)) }}</td>
                        <td class="d-flex gap-1">
                            <x-action.delete route="{{ route('expired.delete', $row->id) }}"></x-action.delete>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
            <div class="pagination">
                {!! $collection->links() !!}
            </div>
        </div>
    </x-container>
@endsection