@extends('layouts.app')
@section('title', 'Purchase List')
@section('content')
    <x-container title="Purchase List" buttonRoute="{{ route('purchase.create') }}" buttonTitle="New Purchase">
        <div class="row justify-content-between mb-1">
            <div class="col-lg-2">
                <select name="paginate" onchange="changePagination(this.value)" id=""
                        class="form-select">
                    <option value="10" selected>{{ translate('common.Show') }}</option>
                    <option value="10" @if (request('paginate') == 10) selected @endif>
                        {{ translate('common.10') }}</option>
                    <option value="20" @if (request('paginate') == 20) selected @endif>
                        {{ translate('common.20') }}</option>
                    <option value="50" @if (request('paginate') == 50) selected @endif>
                        {{ translate('common.50') }}</option>
                    <option value="100" @if (request('paginate') == 100) selected @endif>
                        {{ translate('common.100') }}</option>
                    <option value="200" @if (request('paginate') == 200) selected @endif>
                        {{ translate('common.200') }}</option>
                </select>
            </div>
            <div class="col-lg-6">
                <form action="" class="row">
                    <div class="col-lg-5">
                        <input type="date" value="{{ request('from_date') }}" class="form-control"
                               name="from_date">
                    </div>
                    <div class="col-lg-5">
                        <input type="date" value="{{ request('to_date') }}" class="form-control"
                               name="to_date">
                    </div>
                    <div class="col-lg-2">
                        <button type="submit" class="btn btn-primary">
                            Filter
                        </button>
                    </div>
                </form>
            </div>
            <div class="col-lg-4">
                <form onsubmit="searchKeyword(e)">
                    <input type="text" id="search-keyword" name="keywords"
                           value="{{ request('keywords') ?? '' }}"
                           placeholder="{{ translate('common.Search by invoice') }}" class="form-control">
                </form>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-bordered">
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">{{ translate('common.invoice_id') }}</th>
                    <th scope="col">{{ translate('common.Manufacture') }}</th>
                    <th scope="col">{{ translate('common.Date') }}</th>
                    <th scope="col">{{ translate('common.Quantity') }}</th>
                    <th scope="col">{{ translate('common.Subtotal') }}</th>
                    <th scope="col">{{ translate('common.Discount') }}</th>
                    <th scope="col">{{ translate('common.Total') }}</th>
                    <th scope="col">{{ translate('common.Paid') }}</th>
                    <th scope="col">{{ translate('common.Payable') }}</th>
                    <th scope="col">{{ translate('common.Return') }}</th>
                    <th scope="col">{{ translate('common.Action') }}</th>
                </tr>
                <tbody>

                @forelse($purchases as $purchase)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $purchase->inv_id }}</td>
                        <td>{{ $purchase->supplier ? $purchase->supplier->name : '-' }}</td>
                        <td>{{ $purchase->date }}</td>
                        <td class="text-center">{{ $purchase->qty }}</td>
                        <td class="text-center">{{ priceFormat($purchase->subtotal) }}</td>
                        <td class="text-center">{{ priceFormat($purchase->discount) }}</td>
                        <td class="text-center">{{ priceFormat($purchase->total_price) }}</td>
                        <td>{{ priceFormat($purchase->paid_amount) }}</td>
                        <td class="text-center">{{ priceFormat($purchase->due_price) }}</td>
                        <td class="text-center">{{ priceFormat($purchase->change_amount) }}</td>
                        <td>
                            <a href="{{ route('purchase.show', $purchase->id) }}"
                               class="btn btn-success btn-sm mb-1"><i class="fa fa-eye"></i></a>
                            <a href="{{ route('purchase.return.form', $purchase->id) }}"
                               class="btn btn-warning btn-sm mb-1"><i class="fa fa-undo"></i></a>
                            <a onclick="return confirm('{{ translate('common.Are you sure to delete') }}')"
                               href="{{ route('purchase.destroy', $purchase->id) }}"
                               class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="10" class="text-center">
                            <h4 class="py-4">{{ translate('common.No date found') }}!</h4>
                        </td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
        <div class="pagination mt-2">
            {!! $purchases->links() !!}
        </div>
    </x-container>
@endsection

@section('custom-js')
    <script>
        function changePagination(paginate) {
            var nurl = new URL('{{ route('purchase.index') }}');
            nurl.searchParams.set('paginate', paginate);
            location.href = nurl;
        }


        function searchKeyword(e) {
            e.preventDefault();
            let keyword = $('#search-keyword')
            var nurl = new URL('{{ route('purchase.index') }}');
            nurl.searchParams.set('keywords', keyword);
            location.href = nurl;
        }
    </script>
@endsection
