@php
    $subtotal = 0;
    $total_discount = 0;
    $medicine_discount_amount = 0;
    $invoice_descount_amount = 0;
    $total_quantity = 0;
@endphp
<div class="table-responsive">
    <table class="table purchase-product-table table-striped mb-2">
        <thead>
            <tr>
                <th>#</th>
                <th>{{ translate('common.medicine') }}</th>
                <th>{{ translate('common.batch') }}</th>
                <th>{{ translate('common.Expire Date') }}</th>
                <th>{{ translate('common.MRP Per Unit') }}</th>
                <th>{{ translate('common.Buy Price Per Unit') }}</th>
                <th>{{ translate('common.Quantity') }}</th>
                <th>{{ translate('common.Subtotal') }}</th>
                <th>{{ translate('common.Discount') }}</th>
                <th>{{ translate('common.Total') }}</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @forelse($purchase_cart as $key => $cart)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td class="d-flex gap-1 align-items-center">
                        @if (!empty($cart['image']))
                            <img src="{{ @globalAsset($cart['image']) }}" height="35" width="35"
                                alt="">
                        @else
                            <img src="{{ asset('storage/images/medicine/default.png') }}" height="35" width="35"
                                alt="">
                        @endif
                        <strong>{{ @$cart['name'] }}</strong>
                    </td>
                    <td>
                        <input required class="text-uppercase" type="text"
                            onchange="changeHandler(this.value,'{{ $key }}','batch_name')"
                            value="{{ @$cart['batch_name'] }}">
                    </td>
                    <td>
                        <input required onchange="changeHandler(this.value,'{{ $key }}','expire_date')"
                            style="width: 115px;" type="date" value="{{ @$cart['expire_date'] }}">
                    </td>
                    <td>
                        <input required step="any"
                            onchange="changeHandler(this.value,'{{ $key }}','price')" type="number"
                            value="{{ @$cart['price'] }}">
                    </td>
                    <td>
                        <input required step="any"
                            onchange="changeHandler(this.value,'{{ $key }}','buy_price')" type="number"
                            value="{{ @$cart['buy_price'] }}">
                    </td>
                    <td>
                        <input required onchange="changeHandler(this.value,'{{ $key }}','quantity')"
                            type="number" value="{{ @$cart['quantity'] }}">
                    </td>
                    <td>
                        {{ priceFormat(@$cart['buy_price'] * @$cart['quantity']) }}
                    </td>
                    <td>
                        <input onchange="changeHandler(this.value,'{{ $key }}','discount')" type="number"
                            value="{{ @$cart['discount'] }}">
                        <select onchange="changeHandler(this.value,'{{ $key }}','discount_value_type')">
                            <option value="percent" @if (@$cart['discount_value_type'] == 'percent') selected @endif>%
                            </option>
                            <option value="fixed" @if (@$cart['discount_value_type'] == 'fixed') selected @endif>Fixed
                            </option>
                        </select>
                    </td>
                    <td>
                        @php
                            $productPrice = @$cart['buy_price'] * @$cart['quantity'];
                            $productDiscountAmount = calculateDiscountedPrice($productPrice,@$cart['discount'],@$cart['discount_value_type']);
                            $productTotalPrice = $productPrice - $productDiscountAmount;
                        @endphp
                        {{ priceFormat($productTotalPrice) }}
                    </td>
                    <td>
                        <a href="javascript:" onclick="removePurchaseItem('{{ $key }}')"
                            class="text-danger"><i class="fa fa-times"></i></a>
                    </td>
                </tr>
                @php
                    $medicine_discount_amount += $productDiscountAmount;
                    $total_discount += $productDiscountAmount;
                    $subtotal += $productTotalPrice;
                    $total_quantity += @$cart['quantity'];
                @endphp
            @empty
                <tr>
                    <td colspan="11" class="text-center">
                        <h5 class="font-weight-bold py-2">{{ translate('common.Purchase cart empty') }}</h5>
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
<div class="row justify-content-end">
    <div class="col-lg-5">
        <div class="float-end">
            <table class="table estimate-acount-table text-right">
                <tr>
                    <th>{{ translate('common.Subtotal') }}</th>
                    <td>:</td>
                    <td>{{ priceFormat($subtotal) }}</td>
                    <input type="hidden" id="invoiceSubtotal" name="invoice_subtotal_amount" value="{{ $subtotal }}">
                </tr>
                <tr>
                    <th>{{ translate('common.Medicines Discount') }}</th>
                    <td>:</td>
                    <td>
                        {{ priceFormat($medicine_discount_amount) }}
                    </td>
                    <input type="hidden" id="medicineDiscountAmount" name="medicine_discount" value="{{ $medicine_discount_amount }}">
                </tr>
                <tr>
                    <th>{{ translate('common.Invoice Discount') }}</th>
                    <td>:</td>
                    <td>
                        <input id="invoiceDiscountValue" onchange="calculateInvoiceDiscount()" name="invoice_discount_amount"
                            type="number" value="{{ @$invoice_summary['invoice_discount_value'] }}" step="any" min="0">
                        <select id="invoiceDiscountType" onchange="calculateInvoiceDiscount()" name="invoice_discount_type">
                            <option {{ @$invoice_summary['invoice_discount_type'] == 'percent' ? 'selected' :'' }} value="percent">%</option>
                            <option {{ @$invoice_summary['invoice_discount_type'] == 'fixed' ? 'selected' :'' }} value="fixed">{{ translate('common.Fixed') }}</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    @php
                        $invoice_discount = calculateDiscountedPrice($subtotal,@$invoice_summary['invoice_discount_value'],@$invoice_summary['invoice_discount_type']);
                        $total_discount += $invoice_discount;
                    @endphp
                    <th>{{ translate('common.Invoice Discount Amount') }}</th>
                    <td>:</td>
                    <td><span id="invoiceDiscountText">{{ priceFormat($invoice_discount) }}</span></td>
                    <input type="hidden" id="invoiceDiscountAmount" name="invoice_discount_amount" value="{{ $invoice_discount }}">
                </tr>
                <tr>
                    <th>{{ translate('common.Total Discount Amount') }}</th>
                    <td>:</td>
                    <td><span id="totalDiscountText">{{ priceFormat($medicine_discount_amount + $invoice_discount) }}</span></td>
                    <input type="hidden" id="totalDiscountAmount" name="total_discount" value="{{ $medicine_discount_amount + $invoice_discount }}">
                </tr>
                <tr>
                    <th>{{ translate('common.Total') }}</th>
                    <td>:</td>
                    <td><span id="totalText">{{ priceFormat($subtotal - $invoice_discount) }}</span></td>
                    <input type="hidden" id="totalAmount" name="total" value="{{ $subtotal - $invoice_discount }}">
                </tr>
                <tr>
                    <th>{{ translate('common.Paid Amount') }}</th>
                    <td>:</td>
                    <td>
                        <input step="any" onkeyup="calculateDueAmount()" id="paidAmount" type="number" name="paid"
                            value="{{ $subtotal - $invoice_discount }}">
                    </td>
                </tr>
                <tr>
                    <th>{{ translate('common.Payable Amount') }}</th>
                    <td>:</td>
                    <td>
                        <input id="dueAmount" readonly  class="disabled"  type="number" name="due_amount" value="0">
                    </td>
                </tr>
                <tr>
                    <th>{{ translate('common.Change Amount') }}</th>
                    <td>:</td>
                    <td>
                        <input id="changeAmount" readonly  class="disabled"  type="number" name="change_amount" value="0">
                    </td>
                </tr>
                <tr>
                    <th>{{ translate('common.Payment Method') }}</th>
                    <td>:</td>
                    <td>
                        @php
                            $payment_methods = \App\Models\Method::groupBy('name')
->select('id', 'name','balance')->get();
                        @endphp
                        <select style="width: 100%;" name="payment_method_id">
                            <option value="">{{ translate('common.Select One') }}</option>
                            @foreach ($payment_methods as $payment_method)
                                <option value="{{ $payment_method->id }}"
                                    {{ old('payment_method_id') == $payment_method->id ? 'selected' : '' }}>
                                    {{ $payment_method->name }} - {{ priceFormat($payment_method->balance) }}
                                </option>
                            @endforeach
                        </select>
                        <span class="text-danger">
                            @error('payment_method_id')
                                {{ $message }}
                            @enderror
                        </span>
                    </td>
                    <input type="hidden" name="total_quantity" value="{{ $total_quantity }}">
                </tr>
            </table>
        </div>
    </div>
</div>
