@extends('layouts.app')
@section('title', translate('common.customer_list'))

@section('content')
    <x-container title="Notification">
        <div class="row">
            <div class="col-lg-4">
                <div class="bg-white shadow-sm p-1 rounded-3">
                    <h4 class="mb-2">Send Notification</h4>
                    <form action="{{ route('admin.notification.send') }}" class="row" method="post">
                        @csrf
                        <x-form.input label="Title" name="title" :required="true" col="col-lg-12"></x-form.input>
                        <x-form.textarea label="Description" name="description" col="col-lg-12"></x-form.textarea>
                        <div class="col-lg-12">
                            <button type="submit"
                                    class="btn btn-success">{{ translate('common.Send Notification') }}</button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="bg-white shadow-sm p-1 rounded-3">
                    <h4 class="mb-2">Notification History</h4>
                    <div class="col-lg-12">
                        <div class="row">
                            <div class="table-responsive">
                                <table class="table align-items-center">
                                    <tbody>
                                    @foreach ($collection ?? [] as $row)
                                        <tr>
                                            <td>
                                                <a href="{{ route('notification.show', $row->id) }}">
                                        <span
                                                class="{{ $row->seen ? 'text-muted' : 'text-dark' }}">{{ $row->title }}</span>
                                                    <p class="text-dark">
                                                        {{ $row->description }}
                                                    </p>
                                                </a>

                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="pagination">
                                {!! $collection->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </x-container>
@endsection
@push('css')
    <style>
        .page-wrapper .card .card-body {
            padding: 0
        }
        .page-wrapper .card {
            border-top: none !important;
            background: transparent;
            border-radius: 0;
            box-shadow: none;

        }
    </style>
@endpush