@extends('layouts.app')
@section('title', 'Export & Import')

@section('content')
    <x-container title="Export & Import">
        <div class="row">
            <div class="col-lg-4 border-right">
                <h4>{{ translate('common.Product CSV Uploder') }}</h4>
                <form action="{{ route('medicines.import.process') }}" id="contentForm"
                      enctype="multipart/form-data" method="post">
                    @csrf
                    <div class="mt-2">
                        <input type="file" name="medicines" accept="text/csv">
                        <button type="submit" class="btn btn-success mt-2 w-100">
                            <i class="fas fa-cloud-upload"></i>{{ translate('common.Upload Now') }}
                        </button>
                        @error('medicines')
                        <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                </form>
            </div>
            <div class="col-lg-8">
                <h6>{{ translate('common.Important Notes:') }}</h6>
                <ol>
                    <li>{{ translate('common.Click here to') }} <code><a download="medicines"
                                                                         href="{{ asset('medicine_sample.csv') }}"><i
                                        class="fas fa-download"></i>
                                {{ translate('common.Download Sample') }}
                                {{ translate('common.CSV') }}</a></code></li>
                    <li>{{ translate('common.The sample') }}
                        <code>{{ translate('common.CSV') }}</code>
                        {{ translate('common.file will download to your computer') }}.</li>
                    <li>
                        {{ translate('common.Open the downloaded') }}
                        <code>{{ translate('common.CSV') }}</code>{{ translate('common.file in a spreadsheet program (such as Microsoft Excel or Google Sheets) to view its format') }}
                        .
                    </li>
                    <li>{{ translate('common.Upload or list your product data and upload the file') }}.
                    </li>
                    <li>{{ translate('common.The uploaded file extension must be') }}<code>.{{ translate('common.csv') }}</code>
                    </li>
                    <p class="mt-1"><b>{{ translate('common.Notes') }}:
                        </b>{{ __('Before uploading your medicine list you need
                                                                                                to know Supplier’s id, vendor’s id, Unit’s id, leaf’s id to put into
                                                                                                main CSV file to upload perfectly. Please click bellow and download
                                                                                                following CSV files to know your existing ids') }}
                    </p>

                    <li>{{ __('Click here to') }} <code><a
                                    href="{{ route('medicines.csv.exporter', 'product_categories') }}"><i
                                        class="fas fa-download"></i>
                                {{ translate('common.Download Categories CSV') }} </a></code>
                    </li>
                    <li>{{ __('Click here to') }} <code>
                            <a href="{{ route('medicines.csv.exporter', 'suppliers') }}">
                                <i class="fas fa-download"></i>
                                {{ translate('common.Download Suppliers CSV') }}</a>
                        </code>
                    </li>
                    <li>{{ __('Click here to') }} <code>
                            <a href="{{ route('medicines.csv.exporter', 'vendors') }}">
                                <i class="fas fa-download"></i>
                                {{ translate('common.Download Vendors CSV') }}
                            </a>
                        </code>
                    </li>
                    <li>{{ __('Click here to') }} <code><a
                                    href="{{ route('medicines.csv.exporter', 'units') }}"><i
                                        class="fas fa-download"></i>
                                {{ translate('common.Download Units CSV') }}</a></code></li>
                    <li>{{ __('Click here to') }} <code>
                            <a href="{{ route('medicines.csv.exporter', 'leaves') }}"><i
                                        class="fas fa-download"></i>{{ translate('common.Download Leaf CSV') }}
                            </a></code>
                    </li>
                    <li>{{ __('Click here to') }} <code>
                            <a href="{{ route('medicines.csv.exporter', 'types') }}"><i
                                        class="fas fa-download"></i>{{ translate('common.Download Types CSV') }}
                            </a></code>
                    </li>
                </ol>
            </div>
        </div>
    </x-container>
@endsection