<div class="col-md-4 input-component mb-2">
    <label for="" class="form-label fw-bold d-flex justify-content-between align-items-center">
        <span>{{ translate('common.Barcode') }}  <span class="text-danger">*</span></span>
    </label>
    <div class="input-group">
        <input type="text" class="form-control" id="barcode_input" placeholder="Enter Here" value="" name="qr_code">
        <button class="btn btn-outline-secondary" type="button" id="barcodeGenerate"><i class="fa fa-barcode"></i></button>
    </div>
</div>
<x-form.input
        name="name"
        label="Name"
        :required="true"
        value="{{ @old('name', @$medicine->name) }}"
        col="col-md-4">
</x-form.input>
<x-form.input
        name="generic_name"
        label="Generic Name"
        :required="true"
        value="{{ @old('generic_name', @$medicine->generic_name) }}"
        col="col-md-4">
</x-form.input>

<x-form.select
        name="supplier_id"
        label="supplier"
        :required="true"
        addButtonUrl="{{ route('supplier.create') }}"
        col="col-md-4">
    @foreach ($suppliers as $supplier)
        <option {{ old('supplier_id', @$medicine->supplier_id) == $supplier->id ? 'selected':''  }} value="{{ $supplier->id }}">{{ $supplier->name }} </option>
    @endforeach
</x-form.select>
<x-form.select
        name="leaf_id"
        label="Leaf or Box Size"
        addButtonUrl="{{ route('leaf.create') }}"
        col="col-md-4">
    @foreach ($leafs as $leaf)
        <option value="{{ $leaf->id }}" {{ old('leaf_id', @$medicine->leaf_id) == $leaf->id ? 'selected':''  }}>{{ $leaf->name }} ({{ $leaf->amount }})</option>
    @endforeach
</x-form.select>

<x-form.select
        name="vendor_id"
        label="Vendor"
        addButtonUrl="{{ route('vendor.create') }}"
        col="col-md-4">
    @foreach ($vendors as $vendor)
        <option {{ old('vendor_id', @$medicine->vendor_id) == $vendor->id ? 'selected':''  }} value="{{ $vendor->id }}">{{ $vendor->name }} </option>
    @endforeach
</x-form.select>

<x-form.input
        name="quantity"
        label="Quantity"
        value="{{ @old('quantity', @$medicine->quantity) }}"
        col="col-md-4">
</x-form.input>
<x-form.input
        name="price"
        label="price"
        value="{{ @old('price', @$medicine->price) }}"
        col="col-md-4">
</x-form.input>
<x-form.input
        name="buy_price"
        label="Buy Price"
        value="{{ @old('buy_price', @$medicine->buy_price) }}"
        col="col-md-4">
</x-form.input>
<x-form.input
        name="vat"
        label="vat"
        value="{{ @old('vat', @$medicine->vat) }}"
        col="col-md-4">
</x-form.input>
<x-form.input
        name="igta"
        label="igta"
        value="{{ @old('igta', @$medicine->igta) }}"
        col="col-md-4">
</x-form.input>
<x-form.input
        name="shelf"
        label="shelf"
        value="{{ @old('shelf', @$medicine->shelf) }}"
        col="col-md-4">
</x-form.input>
<x-form.input
        name="hns_code"
        label="Hns Code"
        value="{{ @old('hns_code', @$medicine->hns_code) }}"
        col="col-md-4">
</x-form.input>
<x-form.input
        name="strength"
        label="Strength"
        value="{{ @old('strength', @$medicine->strength) }}"
        col="col-md-4">
</x-form.input>

<x-form.file
        name="image"
        label="image"
        value="{{ @old('image', @globalAsset(@$medicine->image)) }}"
        col="col-md-4">
</x-form.file>
<x-form.select
        name="status"
        label="Status"
        :required="true"
        col="col-md-4">
    <option value="active" selected {{ old('status', @$medicine->status) == 'active' ? 'selected':''  }}>{{ translate('Active') }}</option>
    <option value="inactive" {{ old('status', @$medicine->status) == 'inactive' ? 'selected':''  }}>{{ translate('Inactive') }}</option>
</x-form.select>
<x-form.select
        name="type"
        label="Medicine For"
        col="col-md-4">
    <option value="inventory" selected {{ old('type', @$medicine->type) == 'inventory' ? 'selected':''  }}>{{ translate('common.inventory') }}</option>
    <option value="ecommerce"  {{ old('type', @$medicine->type) == 'ecommerce' ? 'selected':''  }}>{{ translate('common.ecommerce') }}</option>
    <option value="global" {{ old('type', @$medicine->type) == 'global' ? 'selected':''  }}>{{ translate('common.both') }}</option>
</x-form.select>
<div class="col-lg-12 mb-3">
    <div class="d-flex gap-2">
        <h4>
            {{ translate('common.Select Categories') }}
        </h4>
        <a href="{{ route('categories.create') }}">{{ translate('Add new') }}</a>
    </div>

    <div class="row">
        @php $selectedCategories = json_decode(@$medicine->categories, true) ?? [] @endphp
        @foreach ($categories as $category)
            <div class="col-lg-3">
                <div class="form-check">
                    <input class="form-check-input" name="product_categories[]" type="checkbox"
                           value="{{ $category->id }}" @if (is_array($selectedCategories)) @if (in_array($category->id, $selectedCategories)) checked @endif
                           @endif id="productCategory{{ $category->id }}">
                    <label class="form-check-label" for="productCategory{{ $category->id }}">
                        {{ $category->title }}
                    </label>
                </div>
            </div>
        @endforeach
    </div>
</div>

<x-form.textarea
        name="description"
        label="Description"
        value="{{ @old('description', $medicine->description) }}"
        col="col-md-12">
</x-form.textarea>
