@extends('layouts.backend')
@section('title', "Expenses")
@section('content')
<x-container title="Expenses" buttonTitle="Add New" buttonRoute="{{ route('expenses.create') }}">
    <div class="table-responsive pt-0">
        <form action="" method="get" class="row mb-2">
            <div class="col-lg-4">
                <input type="date" value="{{ request('date') }}" name="date" class="form-control">
            </div>
            <div class="col-lg-4">
                <button class="btn btn-primary"><i class="fa fa-search"></i></button>
            </div>
        </form>
        <table class="table">
            <x-table.thead :headers="['Date','Category','Expense for','Reference No','Amount','action']"></x-table.thead>
            <tbody>
            @php
            $total = 0;
            @endphp
            @foreach($collection as $row)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $row->date }}</td>
                    <td>{{ $row->category->name }}</td>
                    <td>{{ $row->title }}</td>
                    <td>{{ $row->reference }}</td>
                    <td>{{ priceFormat($row->amount) }}</td>
                    <td class="d-flex gap-1">
                        <x-action.edit route="{{ route('expenses.edit', $row->id) }}"></x-action.edit>
                        <x-action.delete route="{{ route('expenses.delete', $row->id) }}"></x-action.delete>
                    </td>
                </tr>
                @php $total += $row->amount; @endphp
            @endforeach
            <tr>
                <td colspan="5" class="text-end"><b>Total</b></td>
                <td><b>{{ priceFormat($total) }}</b></td>
            </tr>
            </tbody>
        </table>
    </div>
</x-container>
@endsection