@extends('layouts.backend')
@section('title', translate('title.Customers'))
@section('content')
    <x-container title="Customers" buttonTitle="Add New" buttonRoute="{{ route('customer.create') }}">
        <div class="table-responsive pt-0">
            <table class="table">
                <x-table.thead :headers="['name','phone','due','address','Action']"></x-table.thead>
                <tbody>
                @foreach ($collection as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $row->name }}</td>
                        <td>{{ $row->phone }}</td>
                        <td>{{ priceFormat($row->due) }}</td>
                        <td>{{ $row->address }}</td>
                        <td class="d-flex gap-1">
                            <x-action.edit  route="{{ route('customer.edit', $row->id) }}"></x-action.edit>
                            <x-action.show  route="{{ route('customer.show', $row->id) }}"></x-action.show>
                            <x-action.delete route="{{ route('customer.delete', $row->id) }}"></x-action.delete>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <div class="pagination">
                {!! $collection->links() !!}
            </div>
        </div>
    </x-container>
@endsection