@props([
'name' => '',
'label' => '',
'id' => uniqid(),
'type' => 'text',
'placeholder' => 'Enter here',
'option_label' => '--Choose--',
'required' => false,
'col' => 'col-lg-6',
'class' => 'form-select',
'addButtonUrl' => '',
])

<div class="{{ $col }} input-component mb-2">
    <label for="{{ $id }}" class="form-label fw-bold d-flex justify-content-between align-items-center">
        <span>
            {{ translate($label) }} @if($required) <span class="text-danger">*</span> @endif
        </span>
        @if(!empty($addButtonUrl))
            <a href="{{ $addButtonUrl }}">{{ translate('Add New') }}</a>
        @endif
    </label>
    <select {{ $attributes }} name="{{ $name }}" id="{{ $id }}" class="{{ $class }}" {{ $required ? 'required' : '' }}>
        <option value="">{{ $option_label }}</option>
        {{ $slot }}
    </select>

    @error($name)
        <span class="text-danger"><i class="fas fa-warning"></i> {{ $message }}</span>
    @enderror
</div>
