@props([
'name' => '',
'label' => '',
'id' => uniqid(),
'type' => 'text',
'placeholder' => 'Enter here',
'value' => '',
'required' => false,
'col' => 'col-lg-6',
'class' => '',
'addButtonUrl' => '',
])

<div class="{{ $col }} input-component mb-2">
    <label for="{{ $id }}" class="form-label fw-bold d-flex justify-content-between align-items-center">
        <span>
            {{ translate($label) }} @if($required) <span class="text-danger">*</span> @endif
        </span>
        @if(!empty($addButtonUrl))
            <a href="{{ $addButtonUrl }}">{{ translate('Add New') }}</a>
        @endif
    </label>
    <input
            {{ $attributes }}
            type="{{ $type }}"
            id="{{ $id }}"
            placeholder="{{ translate($placeholder) }}"
            class="form-control {{ $class }}"
            value="{{ $value }}"
            name="{{ $name }}"
            {{ $required ? 'required' : '' }}
    >
    {{ $slot }}
    @error($name)
    <span class="text-danger"><i class="fas fa-warning"></i> {{ $message }}</span>
    @enderror
</div>
