<?php

namespace App\Providers;

use App\Models\ProductCategory;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Modules\MultiStore\App\Models\Store;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Paginator::useBootstrap();
        Schema::defaultStringLength(199);
        // \Illuminate\Support\Facades\URL::forceScheme('https');


        if (!empty(env('DB_DATABASE')) && !empty(env('DB_USERNAME'))) {
            if (existsDirectory(resource_path('views/ecommerce')) && existsDirectory(resource_path('views/frontend'))) {
                View::composer('frontend.includes.header', function ($view) {
                    $types = ProductCategory::where('show_in_menu', 1)
                            ->orderBy('sorting')
                            ->limit(7)
                            ->get() ?? [];
                    $view->with('types', $types);
                });
            }
        }

        if (!empty(env('DB_DATABASE')) && !empty(env('DB_USERNAME'))) {
            if (Schema::hasTable('stores') && isModuleActive('MultiStore')) {
                View::composer('*', function ($view) {
                    $stores = Store::pluck('name', 'id');
                    $view->with('stores', $stores);
                });
            }
        }
    }
}