<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PharmacyExpense extends BaseModel
{
    use HasFactory;
    protected $fillable = [
        'date',
        'title',
        'category_id',
        'amount',
        'reference',
        'note',
        'account_id',
    ];

    public function category()
    {
        return $this->belongsTo(ExpenseCategory::class,'category_id','id');
    }
}
