<?php

namespace App\Models\Ecommerce;

use App\Models\Category;
use App\Models\InvoicePay;
use App\Models\Leaf;
use App\Models\Supplier;
use App\Models\Unit;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;
    protected $guarded = [];
    protected $appends = ['discounted_price'];

    public function unit(){
        return $this->belongsTo(Unit::class);
    }

    public function category(){
        return $this->belongsTo(Category::class);
    }

    public function leaf(){
        return $this->belongsTo(Leaf::class);
    }

    public function invoice_pay(){
        return $this->hasMany(InvoicePay::class);
    }

    public function supplier(){
        return $this->belongsTo(Supplier::class);
    }

    public function getDiscountedpriceAttribute()
    {
        $price  =  $this->attributes['price'];
        $discount_amount  = $this->attributes['discount'];
        $discounted_price  =  0;
        if ($discount_amount > 0){
            $discounted_price = $price - ($discount_amount / 100 * $price );
        }else{
            $discounted_price = $price;
        }
        return $discounted_price;
    }


    public static function decrementQty($productId, $qty)
    {
        $product = Product::findOrFail($productId);
        $product->instock = $product->instock - $qty;
        $product->save();
        return true;
    }


}
