<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\URL;

class CustomerForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;


    public function showCustomerLinkRequestForm()
    {
        return view('auth.customer.passwords.email');
    }


    public function sendCustomerResetLinkEmail(Request $request)
    {
        $this->validateEmail($request);

        $user = $this->broker()->getUser($request->only('email'));


        // Generate the reset link using the user instance
        $resetLink = URL::signedRoute(
            'customer.password.reset',
            ['token' => $this->broker()->createToken($user)]
        );
        $response = $this->broker()->sendResetLink(
            $request->only('email'),
            function ($user, $token) use ($resetLink) {
                $user->notify(new ResetPasswordNotification($token, $resetLink));
            }
        );

        return $response == Password::RESET_LINK_SENT
            ? $this->sendResetLinkResponse($request, $response)
            : $this->sendResetLinkFailedResponse($request, $response);
    }

    public function broker()
    {
        return Password::broker('customers'); // Use the customer password broker
    }

    protected function validateEmail(Request $request)
    {
        $request->validate(['email' => 'required|email']);
    }
}
